<?php
/* --------------------------------------------------------------
  JwtController.php 2019-08-05
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

namespace Gambio\StyleEdit\Api\Controllers;

use Exception;
use Firebase\JWT\JWT;
use Gambio\StyleEdit\Core\Components\BasicController;
use Gambio\StyleEdit\Core\TranslatedException;
use Slim\App;
use stdClass;
use StyleEdit4AuthenticationController;

/**
 * Class JwtController
 */
class JwtController extends BasicController
{
    /**
     * @var \Slim\Slim
     */
    protected $app;

    /**
     * @var string
     */
    protected $env;

    /**
     * BasicController constructor.
     *
     * @param App $app
     */
    public function __construct(App $app)
    {
        $this->app = $app;

        $devEnvironmentFilePath = dirname(__DIR__, 5) . DIRECTORY_SEPARATOR . '.dev-environment';
        $this->env = file_exists($devEnvironmentFilePath) ? 'development' : 'production';
    }
    
    
    /**
     * @param array $uri
     *
     * @return mixed
     * @throws Exception
     */
    public function get(array $uri)
    {
        if ($this->env === 'development') {
            $secret     = StyleEdit4AuthenticationController::getSecret();
            $tokenArray = StyleEdit4AuthenticationController::getTokenArray();
            
            $result        = new stdClass;
            $result->token = JWT::encode($tokenArray, $secret);
            
            return $this->outputJson($result);
        }

        throw new TranslatedException('FORBIDDEN', [], 403);
    }
    
    
    /**
     * @param array $uri
     * @param       $data
     *
     * @return mixed
     */
    public function put(array $uri, $data)
    {
        // TODO: Implement put() method.
    }
    
    
    /**
     * @param array $uri
     * @param       $data
     *
     * @return mixed
     */
    public function post(array $uri, $data)
    {
        // TODO: Implement post() method.
    }
    
    
    /**
     * @param array $uri
     * @param       $data
     *
     * @return mixed
     */
    public function delete(array $uri, $data)
    {
        // TODO: Implement delete() method.
    }
    
    
    /**
     * @param array $uri
     * @param       $data
     *
     * @return mixed
     */
    public function patch(array $uri, $data)
    {
        // TODO: Implement patch() method.
    }
    
    
    /**
     * @return BasicController
     */
    public function __clone()
    {
        // TODO: Implement __clone() method.
    }
    
    
    /**
     * @return bool
     */
    public function requiresAuthentication(): bool
    {
        return false;
    }
}